set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use step0503_TS_US_merged_processed, clear
compress

drop if year==.

drop if nuts=="US: California"
drop if nuts=="US: East North Central"
drop if nuts=="US: East South Central"
drop if nuts=="US: Middle Atlantic States"
drop if nuts=="US: East North Central"
drop if nuts=="US: New England"
drop if nuts=="US: Northwest"
drop if nuts=="US: Rocky Mountain state"
drop if nuts=="US: South Atlantic"
drop if nuts=="US: West North Central"
drop if nuts=="US: West South Central"

drop if nuts=="Entire U.S."
drop if nuts=="US: AK"
drop if nuts=="US: HI"
drop if nuts=="US: DC"

gen country="US"

duplicates report nuts country year

capture drop xxx*
capture drop _merge*

rename ts_* *


gen ic_EMP_share_female=EMP_share_female*100


	
*========================================================
*				estimation sample
*========================================================

gen smpl0=0
gen smpl1=0
gen smpl2=0
gen smpl3=0


				
*=================================================================
*				unemployment & employment rates
*=================================================================

replace gdp=gdp/1 if year==1970
replace gdp=gdp/1.05078616054576 if year==1971
replace gdp=gdp/1.09641320099818 if year==1972
replace gdp=gdp/1.15609153128289 if year==1973
replace gdp=gdp/1.25994410969502 if year==1974
replace gdp=gdp/1.37663955608303 if year==1975
replace gdp=gdp/1.45219686675619 if year==1976
replace gdp=gdp/1.54227174373215 if year==1977
replace gdp=gdp/1.65058388514901 if year==1978
replace gdp=gdp/1.78683327822184 if year==1979
replace gdp=gdp/1.94795416915504 if year==1980
replace gdp=gdp/2.12981288440337 if year==1981
replace gdp=gdp/2.26196123763262 if year==1982
replace gdp=gdp/2.35125199660525 if year==1983
replace gdp=gdp/2.43470365066734 if year==1984
replace gdp=gdp/2.5125968429846 if year==1985
replace gdp=gdp/2.56325905840538 if year==1986
replace gdp=gdp/2.62866172240007 if year==1987
replace gdp=gdp/2.720704908384 if year==1988
replace gdp=gdp/2.82647420238657 if year==1989
replace gdp=gdp/2.93103721747946 if year==1990
replace gdp=gdp/3.02858194980664 if year==1991
replace gdp=gdp/3.09762182481344 if year==1992
replace gdp=gdp/3.17135070752637 if year==1993
replace gdp=gdp/3.23885357643574 if year==1994
replace gdp=gdp/3.30643737905094 if year==1995
replace gdp=gdp/3.36678996580359 if year==1996
replace gdp=gdp/3.42440521839931 if year==1997
replace gdp=gdp/3.4615559058634 if year==1998
replace gdp=gdp/3.51100363866386 if year==1999
replace gdp=gdp/3.59078197702036 if year==2000
replace gdp=gdp/3.67301201005613 if year==2001
replace gdp=gdp/3.72946958516959 if year==2002
replace gdp=gdp/3.80402379060227 if year==2003
replace gdp=gdp/3.9082908123742 if year==2004
replace gdp=gdp/4.03365169271426 if year==2005
replace gdp=gdp/4.1576360590963 if year==2006
replace gdp=gdp/4.26798952472867 if year==2007
replace gdp=gdp/4.35134145484687 if year==2008
replace gdp=gdp/4.38484820167487 if year==2009
replace gdp=gdp/4.4379327321952 if year==2010
replace gdp=gdp/4.52508966266522 if year==2011
replace gdp=gdp/4.60417155411226 if year==2012


gen gdp_per_capita=gdp/age_total*1000


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
*	normalize to PPP
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

joinby country using "C:\Dropbox\Oli\Hysteresis\new_data\penn_world_tables_71.dta", unmatched(master)
tab country _merge
drop _merge

capture drop gdp_per_capita1
gen gdp_per_capita1=gdp_per_capita

foreach GGG in 1 {
	capture drop temp_country
	egen temp_country=group(country)
	sum temp_country
	local max1=r(max)
	capture drop gdp_per_capita_PPP
	gen gdp_per_capita`GGG'_PPP=.
	quiet forvalues i =1(1)`max1' {
		sum gdp_per_capita`GGG' [aw = age_total] if year==1970 & temp_country==`i'
		local mean0=r(mean)
		sum pwt71_cgdp if year==1970 & temp_country==`i'
		local mean1=r(mean)
		replace gdp_per_capita`GGG'_PPP=gdp_per_capita`GGG'*`mean1'/`mean0' if temp_country==`i'
	}
	drop temp_country

	capture drop logY_ppp`GGG'
	gen logY_ppp`GGG'=log(gdp_per_capita`GGG'_PPP)*100
	label var logY_ppp`GGG' "log GDP per capita, PPP (PWT)"		
}


rename logY_ppp1 logY_ppp
	
*=================================================================
*					employment structure
*=================================================================

capture drop total_employment
gen total_employment=serv_total+ind_total+ind_agro

capture drop share_emp_primary_sector
gen share_emp_primary_sector = (ind_agro+ind_energy+ind_mining)/total_employment*100
label var share_emp_primary_sector "Share of employment in the primary sector"

capture drop share_emp_secondary_sector
gen share_emp_secondary_sector = (ind_total-ind_energy-ind_mining)/total_employment*100
label var share_emp_secondary_sector "Share of employment in the secondary sector"

capture drop share_emp_tertiary_sector
gen share_emp_tertiary_sector = serv_total/total_employment*100
label var share_emp_tertiary_sector "Share of employment in the tertiary sector"



*=================================================================
*			age structure
*=================================================================
capture drop share_age_*

gen share_age_0_14 = (age_0_4+age_5_9+age_10_14)/age_total*100
gen share_age_15_24 = (age_15_19+age_20_24)/age_total*100
gen share_age_0_24 = share_age_0_14+share_age_15_24

gen share_age_55_64 = (age_55_59+age_60_64)/age_total*100

gen share_age_65plus = (age_65_69 + age_70_plus)/age_total*100

gen share_age_55plus = share_age_65plus+share_age_55_64


*=================================================================
*			education structure
*=================================================================

					
capture drop year_school*

gen year_school_num=0
gen year_school_den=0

forvalues i=0(1)22 {
	replace  year_school_num=year_school_num+edatt_yrs_`i'*`i' if edatt_yrs_`i'~=.
	replace  year_school_den=year_school_den+edatt_yrs_`i' if edatt_yrs_`i'~=.
}
gen year_school=year_school_num/edatt_total
tabstat year_school, by(country) stat(N mean sd min max)

 
*=================================================================
*			migration rates
*=================================================================
capture drop inmig_rate*
capture drop outmig_rate*

gen inmig_rate=inmigration_rate
gen outmig_rate=outmigration_rate

gen inmig_rate_cps=inmigration_rate_cps
gen outmig_rate_cps=outmigration_rate_cps


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				Turnover rates for migration
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

gen turnmig_rate=(inmig_rate+outmig_rate)/2
gen netmig_rate = inmig_rate-outmig_rate 	

gen turnmig_rate_cps=(inmig_rate_cps+outmig_rate_cps)/2
gen netmig_rate_cps = inmig_rate_cps-outmig_rate_cps 	


*========================================================
*				home ownership
*========================================================
capture drop homes_all
egen homes_all=rsum(home_own home_no_own )
capture drop home_own_rate
gen home_own_rate=home_own/homes_all*100

compress


*========================================================
*				nuts dominated by cities
*========================================================
capture drop _merge
joinby nuts using city_nuts, unmatched(master)

replace capital=0 if capital==.
replace city_nuts=0 if city_nuts==.

*** NOTE: DOUBLE CHECK
replace capital=1 	if nuts=="US: DC" & country=="US"
replace city_nuts=1 if nuts=="US: DC" & country=="US"

replace capital=1 	if nuts=="US: Middle Atlantic States" & country=="US"
replace city_nuts=1 if nuts=="US: Middle Atlantic States" & country=="US"



*========================================================
*				nuts dominated by cities
*========================================================

capture drop _merge*

gen nuts1=nuts + " " + string(year)

rename nuts nuts_original
rename nuts1 nuts

* keep if year==1970 | year==1980 | year==1990 | year==2000 | year==2002 | year==2004 | year==2006
gen flag_1970=0
gen impute_all=0

gen year_US=year

order nuts
compress
save wf_step1031, replace

drop impute_all
gen impute_all=1
save wf_step1031_2, replace

sum 			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate  ///
			logY_ppp  city_nuts capital ///
			turnmig_rate_cps netmig_rate
			
